function [z,Pz,Err_KS,Sigma_we] = HGR(x,Nbit,Px,P_target,A,Sigma2,ex,paramDisc,paramHGR)

// Gael Mahe', october 2017

// histogram global reshaping (HGR)

// Inputs and outputs notations refer to the paper

// INPUTS
// x = original signal with integer values
// Nbit = number of bits for integer coding of x
// Px = histogram of x, between -2^(Nbit-1) and 2^(Nbit-1)+1
// P_target = target histogram
// considering H(z) = (1+A(z))/sigma the MA model of x,
// A = sequence of the coefficients of A(z), frame by frame, 
// Sigma2 = sequence of the values of sigma^2
// ex = results from filtering x by H
// paramDisc = discontinuities smoothing parameters
// paramHGR = HGR settings

//OUTPUTS
// z = distribution-equalized signal
// Pz = histogram of z
// Err_KS = Kolmogorov-Smirnov distance at each iteration
// Sigma_we = standard deviation of we at each iteration

// Needed functions
exec("distances.sci");    // Kolmogorov-Smirnov distance
exec("histograms.sci");    // Cumulative histogram
exec("correc_discont.sci");

// Parameters
N = length(x);
M = 2^(Nbit-1)+1;
[nb_blocs,L] = size(A);
block_size = ceil(N/nb_blocs);

// Initializations
z= x;    
Pz=Px;
ez=[zeros(1,L) ex];
Fz = histc(Pz,Nbit);
F_target = histc(P_target,Nbit);
we = zeros(1,N);
Err_KS = zeros(1,1+paramHGR.MAX_IT); Err_KS(1) = dKS(Pz,P_target,Nbit);
disp("dKS = "+string(Err_KS(1)));
Sigma_we = zeros(1,1+paramHGR.MAX_IT);

// Algorithm

iteration=0;
go_on = %T; decreasing_OK = %t;

while go_on
    
   iteration = iteration + 1; 
   disp("iteration "+string(iteration));
   
   // Loop on the whole signal (i = sample number)
   for i=1:N
               
        bloc = floor((i-1)/block_size)+1; // for modele AR of inv mask
        
        // new ez(i) 
        // We verify that the resulting shifts of z are globally acceptable
        // before validating it
        // !! ez has L extra samples at the begining !!
        ez_tmp = ez; z_tmp = z; Pz_tmp = Pz; Fz_tmp=Fz;
        delta_e = paramHGR.sigma_Delta_e*rand(1,1,"normal");
        ez_tmp(i+L) = ez_tmp(i+L) + delta_e;

        // Shifting ez(i) modifies z(i)...z(i+L) 
        // For each z(i+k), we use the model of the block that it belongs to
        
        // a) We do these shifts sample by sample
        // on a "draft Pz" called Pz_tmp
        // and calculate the variation of d = sum|F_ztmp-F_target|^2

        delta_d = 0; 
        for k=0:min(L,N-i)

            // actualize z_tmp(i+k)
            bloc_k = floor((i+k-1)/block_size)+1;
            z_tmp(i+k) = round( (ez_tmp(i+k+L) + A(bloc_k,:)*ez_tmp(i+k+L-1:-1:i+k+L-L)') / (sqrt(Sigma2(bloc_k))+%eps) );
            z_tmp(i+k) = max(z_tmp(i+k),-2^(Nbit-1));    // clipping if needed
            z_tmp(i+k) = min(z_tmp(i+k),2^(Nbit-1)-1);    // clipping if needed

            if z_tmp(i+k) ~= z(i+k) then
                // actu Pz_tmp
                Pz_tmp(z_tmp(i+k)+M) = Pz_tmp(z_tmp(i+k)+M) + 1;
                Pz_tmp(z(i+k)+M) = Pz_tmp(z(i+k)+M) - 1;
                // actu Fz_tmp
                if z_tmp(i+k)<z(i+k) then
                    Ik = z_tmp(i+k):z(i+k)-1;
                    dk_prec = sum((Fz_tmp(Ik+M)-F_target(Ik+M)).^2);
                    Fz_tmp(Ik+M) = Fz_tmp(Ik+M)+1;
                else
                    Ik = z(i+k):z_tmp(i+k)-1;
                    dk_prec = sum((Fz_tmp(Ik+M)-F_target(Ik+M)).^2);
                    Fz_tmp(Ik+M) = Fz_tmp(Ik+M)-1;
                end
                // actu d = sum|F_ztmp-F_target|^2
                delta_d = delta_d + sum((Fz_tmp(Ik+M)-F_target(Ik+M)).^2) - dk_prec;
            end

        end    // of "for k=0:min(L,N-i)"

        // b) If the resulting shifts of z reduce d, we validate  
        if delta_d <= 0 then
            ez = ez_tmp; z = z_tmp;
            Pz = Pz_tmp; Fz = Fz_tmp;
            delta(iteration,i) = 1;
        end   
        we(i) = ez(i+L) - ex(i);
                         
   end // for i
   
   // end of the loop on the whole signal
   
   // Correct discontinuities
   w_disc = z - x;
   w = correc_discont(w_disc,paramDisc);
   z = x + w;
   Pz = histogram(z,Nbit);
   Fz = histc(Pz,Nbit);
   
   // Compute the control parameters
   // and go on for another iteration if needed and possible
   Sigma_we(iteration+1) = stdev(we);
   Err_KS(iteration+1) = max(abs(Fz-F_target))/N;  disp("dKS = "+string(Err_KS(iteration+1)));
   if iteration > 5 then
       decreasing_OK = ( Err_KS(iteration+1-5)-Err_KS(iteration+1) > 50e-4 );
   end
   go_on = (Sigma_we(iteration+1) < 1) & Err_KS(iteration+1) > 5e-4 & iteration < paramHGR.MAX_IT & decreasing_OK;
       
end // while

// Suppress the L extra samples at the begining of ez
ez = ez(L+1:$);

// Shorten Sigma_we and Err_KS
Sigma_we = Sigma_we(1:iteration+1);
Err_KS = Err_KS(1:iteration+1);

endfunction
