function [z,Pz,Err_TV,Sigma_we] = HLR(x,Nbit,Px,P_target,A,Sigma2,ex,paramDisc,paramHLR)

// Gael Mahe', october 2017

// histogram local reshaping (HLR)

// Inputs and outputs notations refer to the paper

// INPUTS
// x = original signal with integer values
// Nbit = number of bits for integer coding of x
// Px = histogram of x, between -2^(Nbit-1) and 2^(Nbit-1)+1
// P_target = target histogram
// considering H(z) = (1+A(z))/sigma the MA model of x,
// A = sequence of the coefficients of A(z), frame by frame, 
// Sigma2 = sequence of the values of sigma^2
// ex = results from filtering x by H
// paramDisc = discontinuities smoothing parameters
// paramHLR = HLR settings

//OUTPUTS
// z = distribution-equalized signal
// Pz = histogram of z
// Err_TV = Total Variation distance at each iteration
// Sigma_we = standard deviation of we at each iteration


// Needed functions
exec("histograms.sci");
exec("distances.sci");
exec("correc_discont.sci");

// Parameters
N = length(x);
M=2^(Nbit-1)+1;
[nb_blocs,L] = size(A);
block_size = ceil(N/nb_blocs);

// Initializations
z= x;    
Pz=Px;
ez=[zeros(1,L) ex];
we = zeros(1,N);
Err_TV = zeros(1,1+paramHLR.MAX_IT); Err_TV(1) = [dist_TV(P_target,Pz)];
Sigma_we = zeros(1,1+paramHLR.MAX_IT);

// Algorithm

iteration=0;
go_on = %T;
disp("dTV = "+string(Err_TV(1)));

while go_on
    
   iteration = iteration + 1; 
   disp("iteration "+string(iteration));
   Err_TV(iteration+1) = Err_TV(iteration);
   
   for i=1:N
               
        bloc = floor((i-1)/block_size)+1; // for modele AR of inv PSD
        
        // new ez(i) 
        // We verify that the resulting shifts of z are globally acceptable
        // before validating it
        // !! ez has L extra samples at the begining !!
        ez_tmp = ez; z_tmp = z; Pz_tmp = Pz;
        // For uniform law, sigma^2 = q^2/12 -> q = sigma*sqrt(12)
        //ez_tmp(i+L) = ez_tmp(i+L) + sigma_delta_e*sqrt(12)*(0.5-rand(1,1,"uniform"));
        ez_tmp(i+L) = ez_tmp(i+L) + paramHLR.sigma_Delta_e*rand(1,1,"normal");
        delta_dTV = 0;

        // Shifting ez(i) modifies z(i)...z(i+L) 
        // For each z(i+k), we use the model of the block that it belongs to
        
        // a) We do these shifts sample by sample
        // on a "draft Pz" called Pz_tmp
        // and compute the variation of dTV

        for k=0:min(L,N-i)

            // actualize z_tmp(i+k)
            bloc_k = floor((i+k-1)/block_size)+1;
            z_tmp(i+k) = round( (ez_tmp(i+k+L) + A(bloc_k,:)*ez_tmp(i+k+L-1:-1:i+k+L-L)') / (sqrt(Sigma2(bloc_k))+%eps) );
            z_tmp(i+k) = max(z_tmp(i+k),-2^(Nbit-1));    // clipping if needed
            z_tmp(i+k) = min(z_tmp(i+k),2^(Nbit-1)-1);   // clipping if needed

            if z_tmp(i+k) ~= z(i+k) then
                // resulting variations of dTV
                if Pz_tmp(z(i+k)+M) > P_target(z(i+k)+M) then
                    delta_dTV = delta_dTV - 1;
                else
                    delta_dTV = delta_dTV + 1
                end
                if Pz_tmp(z_tmp(i+k)+M) < P_target(z_tmp(i+k)+M) then
                    delta_dTV = delta_dTV - 1;
                else
                    delta_dTV = delta_dTV + 1;
                end
                // actu Pz_tmp
                Pz_tmp(z_tmp(i+k)+M) = Pz_tmp(z_tmp(i+k)+M) + 1;
                Pz_tmp(z(i+k)+M) = Pz_tmp(z(i+k)+M) - 1;

            end

        end    // of "for k=0:min(L,N-i)"

        // b) If the resulting shifts of z reduce dTV, we validate            
        if delta_dTV <= 0 then
            ez = ez_tmp; 
            z = z_tmp;
            Pz = Pz_tmp;
            Err_TV(iteration+1) = Err_TV(iteration+1) + delta_dTV/(2*N);
        end   
       we(i) = ez(i+L) - ex(i);
              
                        
   end // for i
   
   // Smooth discontinuities of w
   w_disc = z - x;
   w = correc_discont(w_disc,paramDisc);
   z = x + w;
   Pz = histogram(z,Nbit);
   Err_TV(iteration+1) = dist_TV(P_target,Pz);
   disp("dTV = "+string(Err_TV(iteration+1)));
   
   // ctrl go on
   Sigma_we(iteration+1) = stdev(we);
   go_on = (Sigma_we(iteration+1) < 1) & Err_TV(iteration+1)*10^4 > 100 & iteration < paramHLR.MAX_IT;
    
end // while

// Suppress the L extra samples at the begining of ez
ez = ez(L+1:$);

// Shorten Sigma_we and Err_TV
Sigma_we = Sigma_we(1:iteration+1);
Err_TV = Err_TV(1:iteration+1);

endfunction
