function [z,histn] = HLR_Halalchi2009(hist,histd,Nbit,x_pos)
// Cette fonction implémente l'algorithme de tatouage dopant de déplacement d'échantiloons 
//  dans les classes de l'histogramme empirique

// Arguments d'entrée : Histogramme original, histogrammme cible, nombre de bits de codage,
//  échantillons du signal ordonnés (ordre croissant)

// Arguments de sortie : Signal tatoué qui suit la distribution cible, et son histogramme (= histogramme cible)
  
exec('histograms.sci');

N = length(x_pos);
histcum = histc(hist,Nbit);

Class  = find(hist);                // proba non nulle
B = list();
for i = 1:Class(1)-1
  B(i)=[];                          // classes vides
end
histcum1 = histcum(find(histcum));
B(Class(1)) = x_pos(1:histcum1(1));
for i = 1:length(histcum1)-1                                             
  A = x_pos(histcum1(i)+1:histcum1(i+1)); // Liste des échantillons à l'intérieur d'une classe  
  B($+1) = A;                                                               
end

// Boucle de traitement : construction du nouvel histogramme

histn = zeros(1,2^Nbit);

C = list();
for i = 1:2^Nbit
 C(i)=B(i);                     
end 
 
histn = zeros(1,2^Nbit);  
 
 for i = 1: 2^Nbit -1                              
  if(length(C(i))==histd(i))      // histogramme traité = désiré
   histn(i) = length(C(i));
    
    else
     n = length(C(i)) - histd(i);   

     if (n>0)                                    // excédent d'échantillons
     Y = grand(1,'prm',C(i)');                
     
     // Y = grand(1,'prmm',B(i)(1:hist(i))');        // pour sélectionner les plus anciens
     C(i+1) = [C(i+1),Y(1:n)'];                  // on transfere le surplus à la classe suivante
     C(i) = Y(n+1:$)';                            // on conserve le reste dans la classe actuelle
        
   elseif (n<0 & length(C(i+1))>= abs(n))                //  déficit d'échantillons:nombre suffisant pour la compensation
    Y = grand(1,'prm',C(i+1)');                // on prend aléatoirement n éch. de la classe suivante

    // Y = grand(1,'prm',B(i+1)(1:hist(i+1))');       // sélectionner les plus anciens    
    C(i) = [C(i),Y(1:abs(n))'];                        // on les ajoute à la classe actuelle
    C(i+1)  = Y(abs(n)+1:$)';
   
      else                                           // nombre insuffisant
        j = i;
        d1 = histd(i) - length(C(i)); 
        while (j<2^Nbit-1 & length(C(i))<histd(i))        
         j = j+1;

         if (C(j)~=[]) 
         Y = grand(1,'prm',C(j)');
         m = min(length(Y),d1);
         C(i) = [C(i),Y(1:m)'];
         d1 = histd(i) - length(C(i));        // échantillons manquants apres traitement
         C(j) = Y(m+1:$)';
         
              end                      // end if3     
      end                              // end while
end                                    // end if2

end                                    // end if1
histn(i) = length(C(i));
end                                    // end for


// Reconstruction du signal après traitement
z = zeros(1,N);
for i = 1 :2^Nbit
    z(C(i)) = i - (2^15+1);
end

endfunction
