// Gael Mahe', August 2015
// utilities for application of the quantization theorem

function ddp_fil = histoLPfilter(H,fc,L,S2Z)

    // Low-pass filtering of an histogram
    
    // INPUTS :
    // H = histogram
    // fc = cut-off frequency
    // L = filter length
    // S2Z : Set to zero values <0 ? yes=1 , no=0
    
    
    // output
    // ddp_fil = normalized histogram (sum=1)
                                                                 
    Lh = length(H);     
    t = - Lh/2:1:Lh/2-1;
    
    fc = fc - 3/L;  // correction fc pour prendre en cpte la bande de transition
    
    h_rect = 2*fc*sinc(2*%pi*fc*t);     // impulse response
    //h_rect = fc*sinc(fc*%pi*t).^2;
    h_lim = h_rect(Lh/2-(L-1)/2 +1 : Lh/2+(L-1)/2+1);      // limitation of the IR 
    h_win = h_lim .* window('kr',L,8.6); // ponderation by a Blackman window
    // h_win = h_lim .* window('hn',L); // ponderation by a Hanning window
    
    ddp_fil = convol(H,h_win); 
    
    s = length(ddp_fil) - length(H);    
    ddp_fil = ddp_fil(s/2+1:$-s/2);
    
    if S2Z then
        ddp_fil(ddp_fil<0) = 0;
    end
    
    ddp_fil = ddp_fil/sum(ddp_fil);

endfunction

//******************************************

function xQ = SubQuantize(x,K)
    // sub-quantification with factor K of a signal x with integer values     
    xQ = K*floor((x+K/2)/K);     
endfunction

//******************************************

function [Px_rec,NegPx_rec] = reconstruction(Pxq,N,Nbit,K)
  
  exec("histograms.sci");
  
  b = log2(K);   // Number of suppressed bits
  
  // Frequency response G of the reconstruction filter
  f = -0.5 : 1/2^Nbit :0.5 - 1/2^Nbit;
  H_lp = [zeros(1,length(f)/2-2^(Nbit-b)/2),ones(1,2^(Nbit-b)),zeros(1,length(f)/2-2^(Nbit-b)/2)];
  F = K*sinc(%pi*K*f).*exp(%i*%pi*f)./sinc(%pi*f) ; 
  G = zeros(1,2^Nbit);
  I = find(H_lp);
  G(I) = H_lp(I)./F(I); 

  // zero-padding 
  g = real(fftshift(fft(fftshift(G))));
  g_zp = [g,  zeros(1,2^Nbit)];
  G_zp = ifft(g_zp);
  clear F H_lp G g g_zp I
  
  // Reconstruction Px
  Pxq_zp = [Pxq,  zeros(1,2^Nbit)];
  Fc_xq_zp = ifft(Pxq_zp);
  Px_rec = real(fft(Fc_xq_zp.*G_zp)); 
  Px_rec = Px_rec(2^(Nbit-1)+1:2^(Nbit-1)+2^Nbit);
  Px_rec = Px_rec / sum(Px_rec); 
  
  // ctrl neg
  NegPx_rec = length(find(int(Px_rec*N)<0));
  
  // denormalization
  Px_rec = denorm(Px_rec,N);
  
endfunction
