// Gael Mahe', october 2017
// Compare application of FastICA on original and sparsified signals

clear
stacksize(2e8);

exec("read_wav.sci");
exec("write_wav.sci");


// Input files, without the ".wav" extension 
// Must have the same length
file1 = "audio/lead_vocal_32k"; // original
file1sp = "audio/lead_vocal_32k_tilde";   // sparsified
file2 = "audio/piano_32k"; // orignal
file2sp = "audio/piano_32k_tilde";   // sparsified

// Matrices of input signals
[s1,N,octets,Fs,nb_canaux] = read_wav(file1);
[s2,N,octets,Fs,nb_canaux] = read_wav(file2);
S = [s1; s2]; // original
[s1,N,octets,Fs,nb_canaux] = read_wav(file1sp);
[s2,N,octets,Fs,nb_canaux] = read_wav(file2sp);
S_sp = [s1; s2]; // sparsified

// Mixes
A = [1/3 2/3; 2/3 1/3];
X = A*S; 
X_sp = A*S_sp; 
mixfile = "audio/piano_vocal"; // without the ".wav" extension 
mixfile_sp = "audio/piano_vocal_tilde"; // without the ".wav" extension 
write_wav(X,Fs,mixfile);
write_wav(X_sp,Fs,mixfile_sp);

// Separation
Y = fastica(X); //Y = Y([2 1],:); // if inversion needed
Y_sp = fastica(X_sp); //Y_sp = Y_sp([2 1],:); // if inversion needed

// Save files

file1_sep = "audio/lead_vocal_32k_sep"; // original
file1sp_sep = "audio/lead_vocal_32k_tilde_sep";   // sparsified
file2_sep = "audio/piano_32k_sep"; // orignal
file2sp_sep = "audio/piano_32k_tilde_sep";   // sparsified

write_wav(Y(1,:)*stdev(S(1,:))/stdev(Y(1,:)),Fs,file1_sep);
write_wav(Y_sp(1,:)*stdev(S_sp(1,:))/stdev(Y_sp(1,:)),Fs,file1sp_sep);
write_wav(Y(2,:)*stdev(S(2,:))/stdev(Y(2,:)),Fs,file2_sep);
write_wav(Y_sp(2,:)*stdev(S_sp(2,:))/stdev(Y_sp(2,:)),Fs,file2sp_sep);

