    // Gael Mahe', August 2015
// Apply the quantization theorem to signals with low-passed histograms
// and compare to original signals and signals with histograms low-passed according to [Halalchi2009]

clc
clear
stacksize(1.5*10^8);

// Needed functions
exec("read_wav.sci");
exec("write_wav.sci");
exec("histograms.sci");
exec("QuantizationTheorem.sci"); 
exec("distances.sci");
exec("HLR_Halalchi2009.sci");

// Original and transformed files
original = "audio/sa1_fcjf0_VAD_8k";
transformed = original + "_histoLP"; 

// Recall K and P_target
load(original + "_Ptarget.dat");   

// Original and transformed signals, resp x and z 
// -> histograms Px and Pz, respectively
[x,N,bytes,Fs,nb_channels] = read_wav(original);
[z,N,bytes,Fs,nb_channels] = read_wav(transformed);
Nbit = 8*bytes; 
Px = histogram(x,Nbit);
Pz = histogram(z,Nbit);

// Sub-quantization of x and z -> histograms
Nbit = 16;
xQ = SubQuantize(x,K); PxQ = histogram(xQ,Nbit);
zQ = SubQuantize(z,K); PzQ = histogram(zQ,Nbit);

// Histogram reconstruction
[Px_rec, NegPx_rec] = reconstruction(PxQ,N,Nbit,K);
[Pz_rec, NegPz_rec] = reconstruction(PzQ,N,Nbit,K);
errRec_x = dist_TV(Px,Px_rec);
errRec_z = dist_TV(Pz,Pz_rec);
disp("distTV(Px,Px_rec) = "+string(errRec_x));
disp("distTV(Pz,Pz_rec) = "+string(errRec_z));


//-------------------------------------------------------
// Compare with Halachi 2009 

// HFE : x -> zH, Px -> PzH = P_target
[x_ord,x_pos] = gsort(x,'g','i');
[zH,PzH] = HLR_Halalchi2009(Px,P_target,Nbit,x_pos);
write_wav(zH,Fs,original + "_histoLP_2009");

// Sub-quantization : zH -> zHQ, PzH -> PzHQ
zHQ = SubQuantize(zH,K); PzHQ = histogram(zHQ,Nbit);

// Histogram reconstruction : PzHQ -> PzH_rec
[PzH_rec, NegPzH_rec] = reconstruction(PzHQ,N,Nbit,K);
errRec_zH = dist_TV(PzH,PzH_rec);
disp("distTV(PzH,PzH_rec) = "+string(errRec_zH));

