// Gael Mahe', August 2015
// utilities to filter a signal by a filter with block-varying coefficients

function x = bloc_FIR_filter(e,A,Sigma2)
    
    // Gael Mahe', november 2013

    // filter a signal by a FIR filter with block-varying coefficients

    // filter e by  (1+A(z)) / srqt(Sigma2)
    // with coefficient varying by blocks
    // INPUT :
    //    - e : signal
    //    - A : matrix, each line = coefficients of the filter applied to a block of e
    //    - Sigma2 : vector of the successive gain^2 of the filter
    // OUTPUT : 
    //    x = filtered signal

    N = length(e);
    [nb_blocs,p] = size(A);
    block_size = ceil(N/nb_blocs);
    x = zeros(1,N); e = [zeros(1,p) e];
    
    for n=1:N
        
        bloc = floor((n-1)/block_size)+1;
        x(n) = ( e(n+p) + A(bloc,:)*e(n+p-1:-1:n)' ) / (sqrt(Sigma2(bloc))+%eps);
        
    end
        
endfunction


function e = bloc_recursive_filter(x,A,Sigma2)
    
    // Gael Mahe', november 2013

    // filter a signal by a purely recursive filter with block-varying coefficients

    // filter x by sqrt(Sigma2) / (1+A(z))
    // with coefficient varying by blocks
    // INPUT :
    //    - x : signal
    //    - A : matrix, each line = coefficients of the filter applied to a block of x
    //    - Sigma2 : vector of the successive gain^2 of the filter
    // OUTPUT : 
    //    e = filtered signal
    
    N = length(x);
    [nb_blocs,p] = size(A);
    block_size = ceil(N/nb_blocs);
    e = zeros(1,N+p);
    
    for n=1:N
        
        bloc = floor((n-1)/block_size)+1;
        e(n+p) = sqrt(Sigma2(bloc))*x(n) - A(bloc,:)*e(n+p-1:-1:n)';
        
    end
    
    e = e(p+1:N+p)
    
endfunction
