function [paramMaskingOUT, score] = ctrl_audibility(x,file_name,paramMasking,paramDisc)
    
    // Gael Mahe', october 2017
    
    // compute the MA approximation of the masking threshold 
    // and control the audibility of a noise colored according to this model minus a given attenuation in dB

    // INPUTS
    //    x = original signal
    //    file_name = prefix of the noise file name
    //    paramMasking = masking parameters
    //    paramDisc = discontinuities smoothing parameters
    
    // OUTPUTS
    //    paramMaskingOUT = completed masking parameters
    //    score = perceptual score (MOS, ODG or %nan)

    exec("bloc_filtering.sci");
    exec("correc_discont.sci");
    exec("AR_models.sci");
    
    paramMaskingOUT = paramMasking;
    
    // MA model of x
    select paramMaskingOUT.model
    case 'MPEG1'
        [paramMaskingOUT.A,paramMaskingOUT.Sigma2] = modele_AR_InvMaskMPEG1(x,paramMasking.order,paramMasking.winLength,paramMasking.Fs);   
    case 'invPSD'
        [paramMaskingOUT.A,paramMaskingOUT.Sigma2] = modele_AR_InvSpectre(x,paramMasking.order,paramMasking.winLength);  
    end
    attenuation = paramMasking.attenuation;
    
    // create noise colorated according to the MA model of x
    N = length(x);
    w = rand(1,N,"normal");
    b = bloc_FIR_filter(w,paramMaskingOUT.A,paramMaskingOUT.Sigma2);

    // attenuate discontinuities if required 
    if paramDisc.active then
        b = correc_discont(b,paramDisc)
    end
    
    delta = 1; 
    while delta ~= 0
        // considering H(z) = (1+A(z)) / sigma the MA model of each block,
        // find an attenuation so that a white noise filtered by H and attenuated
        // is inaudible in s
                
        select paramMasking.ObjQualMeasure
        case "PEAQ"
            exec("~/util_scilab/peaq.sci");
            score = peaq(x,x+b/10^(attenuation/20),Fs,"int16"); 
            score_type = "ODG";
        case "PESQ"
            exec("~/util_scilab/pesq.sci");
            [score, mos2] = pesq(x,x+b/10^(attenuation/20),Fs,"int16");
            score_type = "MOS";
        else
            // Simply ear-check the noisy file
            exec("write_wav.sci");
            noisy_file = file_name + "_noisy_att" + string(attenuation) + 'dB';
            write_wav(x+b/10^(attenuation/20),Fs,noisy_file); 
            score = %nan;
        end
        
        // update attenuation
        if paramMasking.ObjQualMeasure=="PEAQ" | paramMasking.ObjQualMeasure=="PESQ" then
             msg = "attenuation = "+string(attenuation)+" dB --> "+score_type+" = "+string(score);
         else
             msg =  "attenuation = "+string(attenuation)+" dB --> please ear-check file "+noisy_file;
        end
       
        delta = evstr(x_dialog([msg; 'Modify attenuation of'],'0'));
        attenuation = attenuation + delta;
        
    end
    
    paramMaskingOUT.attenuation = attenuation;
    
    
endfunction
