function beta_opt = estimationGG_MethMoments(x,beta0,bornes)
    
    // Gael Mahe', november 2013
    // estimate, through the moments method, the shape parameter of a generalized Gaussian (GG) distribution
    
    // INPUTS
    // x = signal assumed GG
    // beta0 = initial search value
    // bornes = search interval
    
    // OUTPUTS
    // beta_opt = estimated shape parameter of the GG distribution

  r = 4;
  mu_x = mean(x);
  B = mean((x-mu_x).^r) / (mean((x-mu_x).^2))^(r/2);
  deff("a=A(b)","a = gamma(1/b)^(r/2-1)*gamma((r+1)/b)/gamma(3/b)^(r/2)");  
  deff("[f,g,ind]=costf(b,ind)",...
          ["f = (A(b) - B)^2";...
          "g = 2*numdiff(A,b)*(A(b)-B)"]);
  [f_opt,beta_opt] = optim(costf,"b",bornes(1),bornes(2),beta0);
  
endfunction
