// Display final cumulative distribution function (CDF), compared to original and target

exec("histograms.sci"); 

// CDFs
Fx = histc(Px,16); 
Fz = histc(Pz,16); 
F_target = histc(P_target,16); 

scf; plot(-2^15:2^15-1,Fx/sum(Px),'k');
plot(-2^15:2^15-1,F_target/sum(P_target),'g');
plot(-2^15:2^15-1,Fz/sum(P_target),'k--');
legend(["$F_x$";"$F_{target}$";"$F_z$"]);

a = gca();
a.font_size=2;
set(a,"data_bounds",[-5000,0;5000,1])
set(a,"margins",[0.07,0.03,0.08,0.07])
legende = a.children(1); set(legende,"font_size",4); set(legende,"legend_location","in_lower_right"); 
courbe1 = a.children(4).children; set(courbe1,"thickness",1); 
courbe2 = a.children(3).children; set(courbe2,"thickness",2); set(courbe2,"foreground",color(128,128,128))
courbe3 = a.children(2).children; set(courbe3,"thickness",4); courbe3.line_style = 3;

title("Original, target and obtained cumulative histograms");
a.title.font_size = 3;
