// Display convergence, in terms of KS distance and sigma_we

Nit = length(Err_KS)-1;

scf; 
f=gcf(); f.axes_size=[610,410];

plot(0:Nit,Sigma_we,'k--');
plot(0:Nit,10*Err_KS,'k'); 

a = gca(); 
a.font_size=3;
set(a,"margins",[0.07,0.02,0.08,0.12])
set(a,"data_bounds",[0,0;Nit,1]);

legend(["$\hat{\sigma}_{w_e}$";"$\mathrm{d}_\mathrm{KS}(f_z,f_{target})\times10$"]);
xlabel("iterations");

legende = a.children(1); set(legende,"font_size",5); 
legende.legend_location = "in_upper_left";
courbe1 = a.children(2).children; set(courbe1,"thickness",2)
courbe2 = a.children(3).children; set(courbe2,"thickness",2)
a.x_label.font_size = 3;

title("Convergence of the sparsification");
a.title.font_size = 3;
