// Display final characteristic function (CF), compared to original and target

Phi_x = ifft(Px);
Phi_z = ifft(Pz);
Phi_target = ifft(P_target);
NFFT = length(Px);

f = 0:16/NFFT:0.5;
scf; plot(f,20*log10(abs(Phi_x(1:16:NFFT/2+1))),'b'); 
plot(f,20*log10(abs(Phi_z(1:16:NFFT/2+1))),'r--');
plot(f,20*log10(abs(Phi_target(1:16:NFFT/2+1))),'k--'); 

legend(["$\Phi_x(\nu)$";"$\Phi_z(\nu)$";"$\Phi_{target}(\nu)$"]);
xlabel("$\mathrm{Normalized}\, \mathrm{frequency} \quad \nu$");
ylabel("(dB)");

a = gca();
set(a,"data_bounds",[0,-100;0.5,-10]);
set(a,"margins",[0.1,0.05,0.12,0.1])
legende = a.children(1); set(legende,"font_size",4); set(legende,"legend_location","in_upper_right"); 
courbe1 = a.children(4).children; set(courbe1,"thickness",1); 
courbe2 = a.children(3).children; set(courbe2,"thickness",2); 
courbe3 = a.children(2).children; set(courbe3,"thickness",1); 
a.x_label.font_size = 3;
a.y_label.font_size = 3;
a.font_size=2;

title(["Characteristic functions (CFs) of the original (x) and modified (z) signals,";"compared to the target CF"]);
a.title.font_size = 3;
