// Display convergence, in terms of TV distance and sigma_we

Nit = length(Err_TV)-1;

scf; 
plot(1:Nit+1,Sigma_we,'k--');
plot(1:Nit+1,10*Err_TV,'k'); 
legend(["$\hat{\sigma}_{w_e}$";"$\mathrm{d}_\mathrm{TV}(f_z,f_{target})\times10$"]);
xlabel("iterations");

a = gca();
a.log_flags = "lnn";
a.x_ticks = tlist(["ticks" "locations" "labels"],[1 2 5 10 20 50 100]',["1";"2";"5";"10";"20";"50";"100"]);
a.font_size=3;
set(a,"margins",[0.08,0.1,0.08,0.12])
legende = a.children(1); set(legende,"font_size",5); set(legende,"legend_location","by_coordinates"); set(legende,"position",[0.3,0.25]);
courbe1 = a.children(2).children; set(courbe1,"thickness",2)
courbe2 = a.children(3).children; set(courbe2,"thickness",2)
a.x_label.font_size = 3;
a.data_bounds = [1,0;100,1.3];
a.tight_limits = "on";

title("Convergence of the histogram lowpass filtering");
a.title.font_size = 3;
