function [z, Sigma_we, Px, Pz, P_target, Err_TV] = histogram_LPfiltering(x,paramMasking,paramDisc,paramHLR,K)
    
    // histogram lowpass-filtering
    
    // Gael Mahe', october 2017
    
    // INPUTS
    // x = original signal with integer values
    // paramMasking = MA model of the masking threshold
    // paramDisc = discontinuities smoothing parameters
    // paramHLR = HLR settings
    // K = future subquantization factor - Px will be low-passed with cut-off frequency 1/2K
        
    //OUTPUTS
    // z = distribution-equalized signal
    // Sigma_we = standard deviation of we at each iteration
    // Px = histogram of x, between -2^(Nbit-1) and 2^(Nbit-1)+1
    // Pz = histogram of z
    // P_target = target histogram
    // Err_TV = Total Variation distance at each iteration
    
    // Needed functions
    exec("histograms.sci");    
    exec("QuantizationTheorem.sci");
    exec("bloc_filtering.sci"); 
    exec("HLR.sci");

    // histogram of x 
    Nbit = 16; 
    Px = histogram(x,Nbit);

    // Target histogram
    fc = 1/(2*K);                             // cut-off frequency
    P_target = histoLPfilter(Px,fc,511,1);         // LP-filtered normalized histo
    P_target = denorm(P_target,N);              // denormalisation 

    // Distribution equalization
    ex = bloc_recursive_filter(x,paramMasking.A,paramMasking.Sigma2*10^(paramMasking.attenuation/10));
    [z,Pz,Err_TV,Sigma_we] = HLR(x,Nbit,Px,P_target,paramMasking.A,paramMasking.Sigma2*10^(paramMasking.attenuation/10),ex,paramDisc,paramHLR);

endfunction
