// Histogram computation utilities

function Px = histogram(x,Nbit)
    
    // Gael Mahe', August 2015

    //  compute the histogram of a signal with integer values

    // input : signal x with integer values between -2^(Nbit-1) and 2^(Nbit-1)-1
    // output : histogram of x, with 1 classe / integer value

    Px=zeros(1,2^Nbit);
    M=2^(Nbit-1)+1;
    
    for i=1:length(x)
        Px(x(i)+M) = Px(x(i)+M) + 1;
    end

endfunction


function Hcum = histc(H,Nbit)
  
    // Gael Mahe', november 2013

    // INPUT :
    // H = histogramme
    // Nbit = number of bits of the samples
    
    // OUTPUT :
    // Hcum = cumulative histogram
    
    Hcum  = zeros(1,2^Nbit);
    Hcum(1) = H(1);
    
    for i = 1:2^(Nbit)-1
      Hcum(i+1) = Hcum(i) + H(i+1);
    end

endfunction


function Hist_denorm = denorm(Hist,N)

    // convert a discrete distribution into an histogram of N samples
    
    // Houssem Halalchi, June 2009
    
    // Input : 
    // Hist = discrete probability density function
    // N = number of samples
    
    // Output :
    // Hist_denorm = Histogram with N samples
    
    Hist_denorm = Hist*N;           
          
    intHist_denorm = int(Hist_denorm);                            
    decim = Hist_denorm - intHist_denorm;     
    intHist_denorm = max(0,intHist_denorm); // Set to 0 values < 0                    
    Nm = N - sum(intHist_denorm);                   // Number of missing samples
    [Q1 Q2] = gsort(decim);                            
    W = Q2(1:Nm);
    intHist_denorm(W) = intHist_denorm(W)+1;
    Hist_denorm = intHist_denorm;  

endfunction

