function [x,N,bytes,Fe,nb_channels] = read_wav(file_name)

    // Gael Mahe', november 2013

// read a wav file, letting the samples in integer values between +/- 2^15

fid = mopen(file_name+".wav",'r');

mseek(4,fid);
file_size = mget(1,'i',fid)+8;

mseek(22,fid);
nb_channels = mget(1,'us',fid);

mseek(24,fid);
Fe = mget(1,'ui',fid);

//nb bytes / sample
mseek(34,fid);
bytes = mget(1,'s',fid)/8;

// nb samples
N = (file_size-44)/bytes;
//N=2194416;

// signal
mseek(44,fid);
select bytes
case 1 then x = mget(N,'uc',fid),
case 2 then x = mget(N,'s',fid),
end
//x = matrix(x,N/nb_channels,nb_channels)';

mclose(fid);

endfunction
