// utilities to deal with silences in audio signals

function activity = activity_detect(x,taille_bloc,seuil_sigma,seuil_max)
       
    // Simple block activity detection based on the signal level
    // Dectect activity if st_deviation(block) > seuil_sigma or max(block) > seuil_max
    
    nb_blocs = length(x)/taille_bloc;
    activity = zeros(1,nb_blocs);
    index = 1:taille_bloc;
    for bloc=1:nb_blocs
        if stdev(x(index))>seuil_sigma | max(x(index))>seuil_max then
            activity(bloc) = 1;
        end
        index = index + taille_bloc;
    end
endfunction

function xA = delete_blanks(x,activity,blockSize)
    // x : line vector
    index_x = 1:blockSize;
    index_xA = 1:blockSize;
    xA = [];
    for bloc = 1:length(activity)
        if activity(bloc) then
            xA(index_xA) = x(index_x);
            index_xA = index_xA + blockSize;
        end
        index_x = index_x + blockSize;
    end
    if activity($) then
        nb_missing_samples = length(x)-blockSize*length(activity);
        xA = [xA x($-nb_missing_samples+1:$)];
    end
endfunction

function x = restore_blanks(xA,s_ori,activity,blockSize)
    // signals = line vectors
    // insert in xA the blanks of s_ori
    index_x = 1:blockSize;
    index_xA = 1:blockSize;
    x = [];
    for bloc = 1:length(activity)
        if activity(bloc) then
            x(index_x) = xA(index_xA);
            index_xA = index_xA + blockSize;
        else
            x(index_x) = s_ori(index_x);
        end
        index_x = index_x + blockSize;
    end
    x = [x xA(index_xA($):$)]; // add missing samples of xA
    nb_missing_samples = length(s_ori) - length(x);
    x = [x s_ori($-nb_missing_samples+1:$)];
endfunction

