function [z, Sigma_we, Px, Pz, P_target, beta_x, beta_z, Err_KS] = sparsification(x,paramMasking,paramDisc,paramHGR)

    // Gael Mahe', october 2017

    // Needed functions
    exec("histograms.sci");    
    exec("bloc_filtering.sci"); 
    exec("estimationGG_MethMoments.sci");
    exec("HGR.sci");

    // histogram of x and form factor beta_x of the generalized Gaussian model
    Nbit = 16; 
    Px = histogram(x,Nbit);
    beta_x = estimationGG_MethMoments(x,1.5,[0.1 3]); // search form factor between 0.1 and 3, starting from 1.5

    // Target histogram
    beta_target = beta_x / 2;
    mu_x = mean(x); sigma_x = stdev(x);
    alpha = sigma_x*sqrt( gamma(1/beta_target)/gamma(3/beta_target) );
    t = -2^(Nbit-1):1:2^(Nbit-1)-1;
    P_target = beta_target*exp(-(abs(t-mu_x)/alpha).^beta_target)/(2*alpha*gamma(1/beta_target));
    N = length(x);
    P_target = denorm(P_target,N);    // so that sum(P_target)=N   

    // Distribution equalization
    ex = bloc_recursive_filter(x,paramMasking.A,paramMasking.Sigma2*10^(paramMasking.attenuation/10)); 
    [z,Pz,Err_KS,Sigma_we] = HGR(x,Nbit,Px,P_target,paramMasking.A,paramMasking.Sigma2*10^(paramMasking.attenuation/10),ex,paramDisc,paramHGR);

    beta_z = estimationGG_MethMoments(z,1.5,[0.1 3]);
    
endfunction




