// Gael Mahe', october 2017
// Main program : tests the HLR algorithm applied to histogram lowpass-filtering

clear
clc
stacksize(1.5e8);

exec("read_wav.sci");
exec("write_wav.sci");
exec("ctrl_audibility.sci"); 
exec("histogram_LPfiltering.sci");

// Input and output files
file_name = "audio/sa1_fcjf0_VAD_8k";
file_name_out = file_name + "_histoLP"; 

// Input signal x
[x,N,bytes,Fs,nb_channels] = read_wav(file_name);

// For discontinuites correction  :
paramDisc = struct(...
                   "active",%t, ...
                   "Wsig",63,...    // refer to M2 in appendix B
                   "Wmed",5,... // refer to M1 in appendix B
                   "blockSize",128,...  // discontinuities occur at block transitions
                   "Lfilt",7... // impulse response length of the LP filter
            );

// Adapt attenuation of the masking threshold model
// considering H(z) = (1+A(z))/sigma the MA approximation of the masking threshold,
// A = sequence of the coefficients of A(z), frame by frame, 
// Sigma2 = sequence of the values of sigma^2
paramMasking = struct(...
                      "model",'invPSD', ... // masking threshold approximated by PSD
                      "order",10, ...   // order of the filter that models it
                      "winLength",256, ...  // masking computed on windows of length winLength 
                      "Fs",Fs, ...  // sampling frequency
                      "A",%nan, ... 
                      "Sigma2",%nan, ...
                      "attenuation",0, ...
                      "ObjQualMeasure",'PESQ' ...   // set 'none' if you don't have PESQ
                     );
[paramMasking, score] = ctrl_audibility(x,file_name,paramMasking,paramDisc);

// Histogram equalization 
paramHLR = struct(...
                  "MAX_IT",100, ... // max number of iterations
                  "sigma_Delta_e",0.25 ...  // standard-deviation of delta_we
                 );
K = 16; // see subsection IV.B
[z, Sigma_we, Px, Pz, P_target, Err_TV] = histogram_LPfiltering(x,paramMasking,paramDisc,paramHLR,K);

// save modified signal, P_target and K
write_wav(z,Fs,file_name_out);
save(file_name + "_Ptarget.dat",'P_target','K');

// display dKS and shape parameters
disp("Final TV distance: "+string(Err_TV($)))

// Display convergence of algo and CFs
exec("fig_HLR_convergence.sce");
exec("fig_HLR_CharFunction.sce");


