// Gael Mahe', october 2017
// Main program : tests the HGR algorithm applied to sparsification

clear
clc
stacksize(1.5e8);

exec("read_wav.sci");
exec("write_wav.sci");
exec("silence_processing.sci");
exec("ctrl_audibility.sci"); 
exec("sparsification.sci");

// Input and output files
file_name = "audio/bass_32k";
file_name_out = file_name + "_tilde"; 

// Input signal s
[s,N,bytes,Fs,nb_channels] = read_wav(file_name);

// Silence suppression  
ADblockSize = 1000;
activity = activity_detect(s,ADblockSize,20,100);
sA = delete_blanks(s,activity,ADblockSize);

// For discontinuites correction  :
paramDisc = struct(...
                   "active",%t, ...
                   "Wsig",255,...    // refer to M2 in appendix B
                   "Wmed",5,... // refer to M1 in appendix B
                   "blockSize",256,...  // discontinuities occur at block transitions
                   "Lfilt",21... // impulse response length of the LP filter
            );

// Adapt attenuation of the masking threshold model
// considering H(z) = (1+A(z))/sigma the MA approximation of the masking threshold,
// A = sequence of the coefficients of A(z), frame by frame, 
// Sigma2 = sequence of the values of sigma^2
paramMasking = struct(...
                      "model",'MPEG1', ... // masking threshold according to MPEG1 model
                      "order",50, ...   // order of the filter that models it
                      "winLength",512, ...  // masking computed on windows of length winLength
                      "Fs",Fs, ... // sampling frequency
                      "A",%nan, ...
                      "Sigma2",%nan, ...
                      "attenuation",0, ...
                      "ObjQualMeasure",'PEAQ' ...  // set 'none' if you don't have PEAQ
                     );
[paramMasking, score] = ctrl_audibility(sA,file_name,paramMasking,paramDisc);

// sparsification
paramHGR = struct(...
                  "MAX_IT",30, ... // max number of iterations
                  "sigma_Delta_e",0.25 ... // standard-deviation of delta_we
                 );
[sA_tilde, Sigma_we, Px, Pz, P_target, beta_x, beta_z, Err_KS] = sparsification(sA,paramMasking,paramDisc,paramHGR);

// Restore original blanks
s_tilde = restore_blanks(sA_tilde,s,activity,ADblockSize);

// save sparsified signal
write_wav(s_tilde,Fs,file_name_out);

// display dKS and shape parameters
disp("Final KS distance:"+string(Err_KS($)))
disp("Shape parameter of the distribution:"+string(beta_x)+" -> "+string(beta_z))

// Display convergence of the algo and final CDF
exec("fig_HGR_CDF.sce");
exec("fig_HGR_convergence.sce");


